/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.chute;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.logistics.chute.ChuteShapes;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.render.ReducedDestroyEffects;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractChuteBlock
extends Block
implements IWrenchable,
IBE<ChuteBlockEntity> {
    public AbstractChuteBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new ReducedDestroyEffects());
    }

    public static boolean isChute(BlockState state) {
        return state.m_60734_() instanceof AbstractChuteBlock;
    }

    public static boolean isOpenChute(BlockState state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.m_60734_()).isOpen(state);
    }

    public static boolean isTransparentChute(BlockState state) {
        return AbstractChuteBlock.isChute(state) && ((AbstractChuteBlock)state.m_60734_()).isTransparent(state);
    }

    @Nullable
    public static Direction getChuteFacing(BlockState state) {
        return !AbstractChuteBlock.isChute(state) ? null : ((AbstractChuteBlock)state.m_60734_()).getFacing(state);
    }

    public Direction getFacing(BlockState state) {
        return Direction.DOWN;
    }

    public boolean isOpen(BlockState state) {
        return true;
    }

    public boolean isTransparent(BlockState state) {
        return false;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.m_9236_().f_46443_) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        DirectBeltInputBehaviour input = BlockEntityBehaviour.get((BlockGetter)entityIn.m_9236_(), BlockPos.m_274446_((Position)entityIn.m_20182_().m_82520_(0.0, 0.5, 0.0)).m_7495_(), DirectBeltInputBehaviour.TYPE);
        if (input == null) {
            return;
        }
        if (!input.canInsertFromSide(Direction.UP)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        ItemStack toInsert = itemEntity.m_32055_();
        ItemStack remainder = input.handleInsertion(toInsert, Direction.UP, false);
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
        }
        if (remainder.m_41613_() < toInsert.m_41613_()) {
            itemEntity.m_32045_(remainder);
        }
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        this.withBlockEntityDo((BlockGetter)world, pos, ChuteBlockEntity::onAdded);
        this.updateDiagonalNeighbour(state, world, pos);
    }

    protected void updateDiagonalNeighbour(BlockState state, Level world, BlockPos pos) {
        BlockState stateToUpdate;
        if (!AbstractChuteBlock.isChute(state)) {
            return;
        }
        AbstractChuteBlock block = (AbstractChuteBlock)state.m_60734_();
        Direction facing = block.getFacing(state);
        BlockPos toUpdate = pos.m_7495_();
        if (facing.m_122434_().m_122479_()) {
            toUpdate = toUpdate.m_121945_(facing.m_122424_());
        }
        if (AbstractChuteBlock.isChute(stateToUpdate = world.m_8055_(toUpdate)) && !world.m_183326_().m_183582_(toUpdate, (Object)stateToUpdate.m_60734_())) {
            world.m_186460_(toUpdate, stateToUpdate.m_60734_(), 1);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove(state, world, pos, newState);
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        this.updateDiagonalNeighbour(state, world, pos);
        for (Direction direction : Iterate.horizontalDirections) {
            BlockPos toUpdate = pos.m_7494_().m_121945_(direction);
            BlockState stateToUpdate = world.m_8055_(toUpdate);
            if (!AbstractChuteBlock.isChute(stateToUpdate) || world.m_183326_().m_183582_(toUpdate, (Object)stateToUpdate.m_60734_())) continue;
            world.m_186460_(toUpdate, stateToUpdate.m_60734_(), 1);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockState updated = this.updateChuteState(pState, pLevel.m_8055_(pPos.m_7494_()), (BlockGetter)pLevel, pPos);
        if (pState != updated) {
            pLevel.m_46597_(pPos, updated);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState above, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        if (direction != Direction.UP) {
            return state;
        }
        return this.updateChuteState(state, above, (BlockGetter)world, pos);
    }

    public void m_6861_(BlockState p_220069_1_, Level world, BlockPos pos, Block p_220069_4_, BlockPos neighbourPos, boolean p_220069_6_) {
        if (pos.m_7495_().equals((Object)neighbourPos)) {
            this.withBlockEntityDo((BlockGetter)world, pos, ChuteBlockEntity::blockBelowChanged);
        } else if (pos.m_7494_().equals((Object)neighbourPos)) {
            this.withBlockEntityDo((BlockGetter)world, pos, chute -> {
                chute.capAbove = LazyOptional.empty();
            });
        }
    }

    public abstract BlockState updateChuteState(BlockState var1, BlockState var2, BlockGetter var3, BlockPos var4);

    public VoxelShape m_5940_(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return ChuteShapes.getShape(p_220053_1_);
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        return ChuteShapes.getCollisionShape(p_220071_1_);
    }

    @Override
    public Class<ChuteBlockEntity> getBlockEntityClass() {
        return ChuteBlockEntity.class;
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        if (!player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)world, pos, be -> {
            if (be.item.m_41619_()) {
                return InteractionResult.PASS;
            }
            player.m_150109_().m_150079_(be.item);
            be.setItem(ItemStack.f_41583_);
            return InteractionResult.SUCCESS;
        });
    }
}

